<?php
declare(strict_types=1);
session_name(app_config()['app']['session_name'] ?? 'offline_stock_sess');
session_start();

require_once __DIR__ . '/../app/db.php';
require_once __DIR__ . '/../app/helpers.php';
require_once __DIR__ . '/../app/flash.php';
require_once __DIR__ . '/../app/auth.php';
require_once __DIR__ . '/../app/csrf.php';

require_login();
$pdo = db();

$q = trim($_GET['q'] ?? '');

$sql = "SELECT m.*, p.sku, p.name AS product_name, u.username
        FROM stock_movements m
        JOIN products p ON p.id=m.product_id
        LEFT JOIN users u ON u.id=m.user_id
        WHERE 1=1";
$params = [];
if ($q !== '') {
  $sql .= " AND (p.sku LIKE ? OR p.name LIKE ? OR m.type LIKE ?)";
  $params[] = "%$q%"; $params[]="%$q%"; $params[]="%$q%";
}
$sql .= " ORDER BY m.id DESC LIMIT 500";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$rows = $stmt->fetchAll();

$title = 'Stock Movements';
require_once __DIR__ . '/../app/header.php';
?>
<h1>Stock Movements</h1>

<div class="panel">
  <form method="get" class="row" style="flex-wrap:wrap;">
    <div class="field" style="margin:0;min-width:260px;flex:1;">
      <label class="small muted">Search</label>
      <input name="q" value="<?= e($q) ?>" placeholder="SKU / Product / Type (IN/OUT/ADJUST)">
    </div>
    <div class="field" style="margin:0;align-self:end;">
      <button type="submit">Search</button>
    </div>
  </form>
</div>

<div class="panel" style="margin-top:14px; overflow:auto;">
  <table class="table">
    <thead>
      <tr>
        <th>Date</th><th>SKU</th><th>Product</th><th>Type</th><th>Qty (Delta)</th><th>Note</th><th>User</th>
      </tr>
    </thead>
    <tbody>
      <?php foreach($rows as $r): ?>
        <tr>
          <td><?= e($r['created_at']) ?></td>
          <td><?= e($r['sku']) ?></td>
          <td><?= e($r['product_name']) ?></td>
          <td><?= e($r['type']) ?></td>
          <td><?= e((string)$r['qty']) ?></td>
          <td><?= e($r['note'] ?? '') ?></td>
          <td><?= e($r['username'] ?? '-') ?></td>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
  <div class="muted small">Showing last 500 movements.</div>
</div>

<?php require_once __DIR__ . '/../app/footer.php'; ?>
