<?php
declare(strict_types=1);
session_name(app_config()['app']['session_name'] ?? 'offline_stock_sess');
session_start();

require_once __DIR__ . '/../app/db.php';
require_once __DIR__ . '/../app/helpers.php';
require_once __DIR__ . '/../app/flash.php';
require_once __DIR__ . '/../app/auth.php';
require_once __DIR__ . '/../app/csrf.php';

require_login();
$pdo = db();

$rows = $pdo->query("SELECT p.*, c.name AS category_name
                     FROM products p
                     LEFT JOIN categories c ON c.id=p.category_id
                     WHERE p.reorder_level IS NOT NULL AND p.stock_qty <= p.reorder_level
                     ORDER BY p.stock_qty ASC, p.name ASC")->fetchAll();

$title = 'Low Stock';
require_once __DIR__ . '/../app/header.php';
?>
<h1>Low Stock Report</h1>

<div class="panel">
  <p class="muted small">Products where <b>stock_qty ≤ reorder_level</b>.</p>
  <div class="actions">
    <a class="btn" href="<?= e(url('/public/quick_update.php')) ?>">Fix in Quick Update</a>
  </div>
</div>

<div class="panel" style="margin-top:14px; overflow:auto;">
  <table class="table">
    <thead><tr><th>SKU</th><th>Name</th><th>Category</th><th>Stock</th><th>Reorder Level</th><th>Price</th></tr></thead>
    <tbody>
      <?php foreach($rows as $p): ?>
        <tr>
          <td><?= e($p['sku']) ?></td>
          <td><?= e($p['name']) ?></td>
          <td><?= e($p['category_name'] ?? '-') ?></td>
          <td><span class="badge bad"><?= e((string)$p['stock_qty']) ?></span></td>
          <td><?= e((string)$p['reorder_level']) ?></td>
          <td><?= e(number_format((float)$p['sell_price'],2)) ?></td>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</div>

<?php require_once __DIR__ . '/../app/footer.php'; ?>
