<?php
declare(strict_types=1);
session_name(app_config()['app']['session_name'] ?? 'offline_stock_sess');
session_start();

require_once __DIR__ . '/../app/db.php';
require_once __DIR__ . '/../app/helpers.php';
require_once __DIR__ . '/../app/flash.php';
require_once __DIR__ . '/../app/auth.php';
require_once __DIR__ . '/../app/csrf.php';

require_login();
$pdo = db();

$cats = $pdo->query("SELECT id,name FROM categories ORDER BY name ASC")->fetchAll();
$category_id = (int)($_GET['category_id'] ?? 0);
$q = trim($_GET['q'] ?? '');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_verify();
  $category_id = (int)($_POST['category_id'] ?? 0);

  $items = $_POST['items'] ?? [];
  $updated = 0;

  foreach ($items as $pid => $row) {
    $pid = (int)$pid;
    $new_price = isset($row['sell_price']) ? (float)$row['sell_price'] : null;
    $new_stock = isset($row['stock_qty']) ? (int)$row['stock_qty'] : null;

    // Load current
    $stmt = $pdo->prepare("SELECT id, sell_price, stock_qty FROM products WHERE id=?");
    $stmt->execute([$pid]);
    $cur = $stmt->fetch();
    if (!$cur) continue;

    $changed = false;
    $pdo->beginTransaction();
    try {
      if ($new_price !== null && (float)$cur['sell_price'] !== $new_price) {
        $pdo->prepare("UPDATE products SET sell_price=?, updated_at=? WHERE id=?")->execute([$new_price, now(), $pid]);
        $pdo->prepare("INSERT INTO price_history(product_id, old_price, new_price, user_id, created_at) VALUES(?,?,?,?,?)")
            ->execute([$pid, (float)$cur['sell_price'], $new_price, current_user()['id'], now()]);
        $changed = true;
      }

      if ($new_stock !== null && (int)$cur['stock_qty'] !== $new_stock) {
        $delta = $new_stock - (int)$cur['stock_qty'];
        $pdo->prepare("UPDATE products SET stock_qty=?, updated_at=? WHERE id=?")->execute([$new_stock, now(), $pid]);
        $pdo->prepare("INSERT INTO stock_movements(product_id,type,qty,note,user_id,created_at) VALUES(?,?,?,?,?,?)")
            ->execute([$pid,'ADJUST',$delta,'Quick update', current_user()['id'], now()]);
        $changed = true;
      }

      $pdo->commit();
      if ($changed) $updated++;
    } catch (Throwable $e) {
      $pdo->rollBack();
      // continue to next row
    }
  }

  flash_set('success', "Updated {$updated} product(s).");
  redirect('/public/quick_update.php?category_id='.$category_id.'&q='.urlencode($q));
}

$sql = "SELECT p.*, c.name AS category_name
        FROM products p LEFT JOIN categories c ON c.id=p.category_id
        WHERE 1=1";
$params = [];
if ($category_id > 0) { $sql .= " AND p.category_id=?"; $params[] = $category_id; }
if ($q !== '') { $sql .= " AND (p.sku LIKE ? OR p.name LIKE ?)"; $params[]="%$q%"; $params[]="%$q%"; }
$sql .= " ORDER BY p.name ASC LIMIT 500";
$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$products = $stmt->fetchAll();

$title = 'Quick Update';
require_once __DIR__ . '/../app/header.php';
?>
<h1>Quick Update (Category-wise)</h1>

<div class="panel">
  <form method="get" class="row" style="flex-wrap:wrap;">
    <div class="field" style="margin:0;min-width:240px;">
      <label class="small muted">Category</label>
      <select name="category_id">
        <option value="0">All</option>
        <?php foreach($cats as $c): ?>
          <option value="<?= e((string)$c['id']) ?>" <?= $category_id===(int)$c['id']?'selected':'' ?>><?= e($c['name']) ?></option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="field" style="margin:0;min-width:260px;flex:1;">
      <label class="small muted">Search</label>
      <input name="q" value="<?= e($q) ?>" placeholder="SKU or Name">
    </div>
    <div class="field" style="margin:0;align-self:end;">
      <button type="submit">Load</button>
    </div>
  </form>
</div>

<div class="panel" style="margin-top:14px;">
  <div class="row space">
    <div>
      <h2 style="margin:0;">Editable list (max 500)</h2>
      <div class="muted small">Change stock & price, then press <b>Save All</b>.</div>
    </div>
    <div class="muted small">Tip: keep product SKU unique for clean ad scaling.</div>
  </div>

  <form method="post">
    <input type="hidden" name="csrf_token" value="<?= e(csrf_token()) ?>">
    <input type="hidden" name="category_id" value="<?= e((string)$category_id) ?>">

    <div style="overflow:auto;margin-top:10px;">
      <table class="table">
        <thead>
          <tr>
            <th>SKU</th><th>Name</th><th>Category</th><th>Price</th><th>Stock</th><th>Reorder</th><th>Status</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach($products as $p):
            $low = ($p['reorder_level'] !== null && (int)$p['stock_qty'] <= (int)$p['reorder_level']);
          ?>
            <tr>
              <td><?= e($p['sku']) ?></td>
              <td><?= e($p['name']) ?></td>
              <td><?= e($p['category_name'] ?? '-') ?></td>
              <td style="min-width:140px;">
                <input type="number" step="0.01" name="items[<?= e((string)$p['id']) ?>][sell_price]" value="<?= e((string)$p['sell_price']) ?>">
              </td>
              <td style="min-width:140px;">
                <input type="number" name="items[<?= e((string)$p['id']) ?>][stock_qty]" value="<?= e((string)$p['stock_qty']) ?>">
              </td>
              <td><?= e($p['reorder_level'] === null ? '-' : (string)$p['reorder_level']) ?></td>
              <td><?= $low ? '<span class="badge bad">LOW</span>' : '<span class="badge ok">OK</span>' ?></td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>

    <div class="actions" style="margin-top:12px;">
      <button type="submit">Save All</button>
      <a class="btn" href="<?= e(url('/public/stock_movements.php')) ?>">View Movements</a>
    </div>
  </form>
</div>

<?php require_once __DIR__ . '/../app/footer.php'; ?>
