<?php
declare(strict_types=1);
session_name(app_config()['app']['session_name'] ?? 'offline_stock_sess');
session_start();

require_once __DIR__ . '/../app/db.php';
require_once __DIR__ . '/../app/helpers.php';
require_once __DIR__ . '/../app/flash.php';
require_once __DIR__ . '/../app/auth.php';
require_once __DIR__ . '/../app/csrf.php';

if (is_logged_in()) redirect('/public/dashboard.php');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_verify();
  $username = trim($_POST['username'] ?? '');
  $password = (string)($_POST['password'] ?? '');
  if ($username === '' || $password === '') {
    flash_set('error', 'Please enter username and password.');
  } else {
    if (login($username, $password)) {
      flash_set('success', 'Welcome back!');
      redirect('/public/dashboard.php');
    }
    flash_set('error', 'Invalid login.');
  }
}

$title = 'Login';
require_once __DIR__ . '/../app/header.php';
?>
<div class="panel" style="max-width:520px;margin:18px auto;">
  <h1>Login</h1>
  <p class="muted small">Offline inventory admin panel (PHP + MySQL).</p>
  <form method="post">
    <input type="hidden" name="csrf_token" value="<?= e(csrf_token()) ?>">
    <div class="field">
      <label>Username</label>
      <input name="username" autocomplete="username" />
    </div>
    <div class="field">
      <label>Password</label>
      <input name="password" type="password" autocomplete="current-password" />
    </div>
    <button type="submit">Sign in</button>
  </form>
</div>
<?php require_once __DIR__ . '/../app/footer.php'; ?>
