<?php
declare(strict_types=1);
session_name(app_config()['app']['session_name'] ?? 'offline_stock_sess');
session_start();

require_once __DIR__ . '/../app/db.php';
require_once __DIR__ . '/../app/helpers.php';
require_once __DIR__ . '/../app/flash.php';
require_once __DIR__ . '/../app/auth.php';
require_once __DIR__ . '/../app/csrf.php';

require_login();

$pdo = db();
$kpi = [
  'products' => (int)$pdo->query("SELECT COUNT(*) c FROM products")->fetch()['c'],
  'categories' => (int)$pdo->query("SELECT COUNT(*) c FROM categories")->fetch()['c'],
  'in_stock' => (int)$pdo->query("SELECT COUNT(*) c FROM products WHERE stock_qty > 0")->fetch()['c'],
  'low_stock' => (int)$pdo->query("SELECT COUNT(*) c FROM products WHERE reorder_level IS NOT NULL AND stock_qty <= reorder_level")->fetch()['c'],
];
$total_stock = (int)$pdo->query("SELECT COALESCE(SUM(stock_qty),0) s FROM products")->fetch()['s'];
$inventory_value = (float)$pdo->query("SELECT COALESCE(SUM(stock_qty * cost_price),0) v FROM products")->fetch()['v'];

$title = 'Dashboard';
require_once __DIR__ . '/../app/header.php';
?>
<h1>Dashboard</h1>

<div class="grid grid-3">
  <div class="panel kpi"><div class="muted small">Products</div><div class="val"><?= e((string)$kpi['products']) ?></div></div>
  <div class="panel kpi"><div class="muted small">Categories</div><div class="val"><?= e((string)$kpi['categories']) ?></div></div>
  <div class="panel kpi"><div class="muted small">Total Units (Stock)</div><div class="val"><?= e((string)$total_stock) ?></div></div>
</div>

<div class="grid grid-2" style="margin-top:14px;">
  <div class="panel">
    <h2>Stock health</h2>
    <div class="row">
      <span class="badge ok">In Stock: <?= e((string)$kpi['in_stock']) ?></span>
      <span class="badge bad">Low Stock: <?= e((string)$kpi['low_stock']) ?></span>
    </div>
    <p class="muted small" style="margin-top:10px;">Tip: Use <b>Quick Update</b> to change stock and price category-wise in one screen.</p>
    <div class="actions">
      <a class="btn" href="<?= e(url('/public/quick_update.php')) ?>">Go to Quick Update</a>
      <a class="btn" href="<?= e(url('/public/reports_low_stock.php')) ?>">View Low Stock</a>
    </div>
  </div>

  <div class="panel">
    <h2>Inventory value (cost)</h2>
    <div class="val"><?= e(number_format($inventory_value, 2)) ?></div>
    <p class="muted small">Calculated as: Σ(stock_qty × cost_price). (Offline estimation)</p>
  </div>
</div>

<?php require_once __DIR__ . '/../app/footer.php'; ?>
