<?php
declare(strict_types=1);
session_name(app_config()['app']['session_name'] ?? 'offline_stock_sess');
session_start();

require_once __DIR__ . '/../app/db.php';
require_once __DIR__ . '/../app/helpers.php';
require_once __DIR__ . '/../app/flash.php';
require_once __DIR__ . '/../app/auth.php';
require_once __DIR__ . '/../app/csrf.php';

require_login();

$pdo = db();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_verify();
  $action = $_POST['action'] ?? '';
  if ($action === 'create') {
    $name = trim($_POST['name'] ?? '');
    if ($name === '') { flash_set('error','Category name required.'); redirect('/public/categories.php'); }
    $stmt = $pdo->prepare("INSERT INTO categories(name, created_at) VALUES(?,?)");
    $stmt->execute([$name, now()]);
    flash_set('success','Category created.');
    redirect('/public/categories.php');
  }
  if ($action === 'delete') {
    $id = (int)($_POST['id'] ?? 0);
    // Block delete if category has products
    $cnt = (int)$pdo->prepare("SELECT COUNT(*) c FROM products WHERE category_id = ?")->execute([$id]) or 0;
    $stmt = $pdo->prepare("SELECT COUNT(*) c FROM products WHERE category_id = ?");
    $stmt->execute([$id]);
    $cnt = (int)$stmt->fetch()['c'];
    if ($cnt > 0) { flash_set('warning','Cannot delete: category has products.'); redirect('/public/categories.php'); }
    $pdo->prepare("DELETE FROM categories WHERE id=?")->execute([$id]);
    flash_set('success','Category deleted.');
    redirect('/public/categories.php');
  }
}

$cats = $pdo->query("SELECT c.*, (SELECT COUNT(*) FROM products p WHERE p.category_id=c.id) product_count
                     FROM categories c ORDER BY c.name ASC")->fetchAll();

$title = 'Categories';
require_once __DIR__ . '/../app/header.php';
?>
<h1>Categories</h1>

<div class="grid grid-2">
  <div class="panel">
    <h2>Add category</h2>
    <form method="post">
      <input type="hidden" name="csrf_token" value="<?= e(csrf_token()) ?>">
      <input type="hidden" name="action" value="create">
      <div class="field">
        <label>Category name</label>
        <input name="name" placeholder="e.g. Punjabi, Shoes, Gadgets" />
      </div>
      <button type="submit">Create</button>
    </form>
  </div>

  <div class="panel">
    <h2>All categories</h2>
    <table class="table">
      <thead><tr><th>Name</th><th>Products</th><th>Action</th></tr></thead>
      <tbody>
        <?php foreach ($cats as $c): ?>
          <tr>
            <td><?= e($c['name']) ?></td>
            <td><?= e((string)$c['product_count']) ?></td>
            <td>
              <form method="post" onsubmit="return confirm('Delete this category?');">
                <input type="hidden" name="csrf_token" value="<?= e(csrf_token()) ?>">
                <input type="hidden" name="action" value="delete">
                <input type="hidden" name="id" value="<?= e((string)$c['id']) ?>">
                <button type="submit">Delete</button>
              </form>
            </td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>

<?php require_once __DIR__ . '/../app/footer.php'; ?>
