<?php
declare(strict_types=1);

function app_config(): array {
  static $cfg = null;
  if ($cfg !== null) return $cfg;

  $path = __DIR__ . '/config.php';
  if (!file_exists($path)) {
    // fallback to example to show a helpful error
    $path = __DIR__ . '/config.example.php';
  }
  $cfg = require $path;
  return $cfg;
}

function db(): PDO {
  static $pdo = null;
  if ($pdo !== null) return $pdo;

  $cfg = app_config()['db'];
  $dsn = "mysql:host={$cfg['host']};dbname={$cfg['name']};charset={$cfg['charset']}";
  $pdo = new PDO($dsn, $cfg['user'], $cfg['pass'], [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    PDO::ATTR_EMULATE_PREPARES => false,
  ]);
  return $pdo;
}
