<?php
declare(strict_types=1);

function is_logged_in(): bool {
  return !empty($_SESSION['user']);
}

function require_login(): void {
  if (!is_logged_in()) redirect('/public/index.php');
}

function current_user(): ?array {
  return $_SESSION['user'] ?? null;
}

function login(string $username, string $password): bool {
  $stmt = db()->prepare("SELECT id, username, full_name, role, password_hash, is_active FROM users WHERE username = ? LIMIT 1");
  $stmt->execute([$username]);
  $u = $stmt->fetch();
  if (!$u) return false;
  if ((int)$u['is_active'] !== 1) return false;
  if (!password_verify($password, $u['password_hash'])) return false;

  unset($u['password_hash']);
  $_SESSION['user'] = $u;
  return true;
}

function logout(): void {
  unset($_SESSION['user']);
}
